'use strict';

/* --------------------------------------------------------------
 module_center.js 2018-08-28
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2017 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * ## Module Center
 *
 * This module will handle the click events on the module center page
 *
 * @module Controllers/module_center
 */
gx.controllers.module('module_center', [jse.source + '/vendor/datatables/jquery.dataTables.min.css', jse.source + '/vendor/datatables/jquery.dataTables.min.js', 'datatable'],

/**  @lends module:Controllers/module_center */

function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLES DEFINITION
    // ------------------------------------------------------------------------

    var
    /**
     * Module Selector
     *
     * @var {object}
     */
    $this = $(this),


    /**
     * Default Options
     *
     * @type {object}
     */
    defaults = {},


    /**
     * Elements
     *
     * @type {object}
     */
    elements = {

        form: $('.bottom-save-bar form'),

        /**
         * Install Button
         *
         * @type {jQuery}
         */
        installButton: $('.bottom-save-bar form button[name="install"]'),

        /**
         * Uninstall Button
         *
         * @type {jQuery}
         */
        uninstallButton: $('.bottom-save-bar form button[name="uninstall"]'),

        /**
         * Edit Button
         *
         * @type {jQuery}
         */
        editButton: $('.bottom-save-bar form a.btn'),

        /**
         * Module Hidden Field
         *
         * @type {jQuery}
         */
        hiddenModule: $('.bottom-save-bar form input[name="module"]')
    },


    /**
     * Final Options
     *
     * @var {object}
     */
    options = $.extend(true, {}, defaults, data),


    /**
     * Module Object
     *
     * @type {object}
     */
    module = {};

    // ------------------------------------------------------------------------
    // PRIVATE METHODS
    // ------------------------------------------------------------------------

    var _loadModuleData = function _loadModuleData(module) {

        $.ajax({
            url: 'admin.php?do=ModuleCenter/GetData&module=' + module,
            type: 'GET',
            dataType: 'json'
        }).done(function (data) {
            if (data.success) {
                $('.configuration-box-header h2').html(data.payload.title);
                $('.configuration-box-description p').html(data.payload.description);

                elements.editButton.attr('href', 'admin.php?do=' + data.payload.name + 'ModuleCenterModule');

                if (data.payload.isInstalled) {
                    //$('.gx-configuration-box form').attr('action', 'admin.php?do=ModuleCenter/Destroy');
                    elements.uninstallButton.show();
                    elements.editButton.show();
                    elements.installButton.hide();
                } else {
                    elements.form.attr('action', 'admin.php?do=ModuleCenter/Store');
                    elements.uninstallButton.hide();
                    elements.editButton.hide();
                    elements.installButton.show();
                }

                if (!data.payload.isEditable) {
                    elements.editButton.hide();
                }

                elements.hiddenModule.val(data.payload.name);
                $('.gx-configuration-box').css('visibility', 'visible');
            }
        });
    };

    var _openUninstallDialog = function _openUninstallDialog(event) {
        event.preventDefault();
        var $dialog = $('#module-center-confirmation-dialog'),
            module = elements.hiddenModule.val();

        $dialog.find('.modal-info-text').html(jse.core.lang.translate('text_uninstall_confirmation', 'module_center'));
        $dialog.find('input[name="module"]').val(module);

        $dialog.dialog({
            'title': jse.core.lang.translate('uninstall_confirmation_title', 'module_center').replace('%s', module),
            'modal': true,
            'dialogClass': 'gx-container',
            'buttons': [{
                'text': jse.core.lang.translate('close', 'buttons'),
                'class': 'btn',
                'click': function click() {
                    $(this).dialog('close');
                }
            }, {
                'text': jse.core.lang.translate('uninstall', 'buttons'),
                'class': 'btn btn-primary',
                'click': function click() {
                    $dialog.find('form').submit();
                }
            }]
        });
    };

    var queryString = function (a) {
        if (a === '') {
            return {};
        }
        var b = {};
        for (var i = 0; i < a.length; ++i) {
            var p = a[i].split('=', 2);
            if (p.length === 1) {
                b[p[0]] = '';
            } else {
                b[p[0]] = decodeURIComponent(p[1].replace(/\+/g, ' '));
            }
        }
        return b;
    }(window.location.search.substr(1).split('&'));

    // ------------------------------------------------------------------------
    // EVENT HANDLERS
    // ------------------------------------------------------------------------

    var _hashChange = function _hashChange() {
        var module = window.location.hash.substring(1);

        if (module !== '') {
            _loadModuleData(module);
        }
    };

    var _setRowActive = function _setRowActive() {
        $('.gx-modules-table .dataTableRow.active').removeClass('active');

        $(this).addClass('active');

        $('html, body').animate({
            scrollTop: 0
        });
    };

    var _removeParam = function _removeParam(key, sourceURL) {
        var URL = sourceURL.split("?")[0];
        var params = [];
        var queryString = sourceURL.indexOf("?") !== -1 ? sourceURL.split("?")[1] : "";

        if (queryString !== "") {
            params = queryString.split("&");
            for (var i = params.length - 1; i >= 0; i -= 1) {
                var param = params[i].split("=")[0];
                if (param === key) {
                    params.splice(i, 1);
                }
            }
            URL = URL + "?" + params.join("&");
        }
        window.history.pushState({}, document.title, URL);
    };

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    module.init = function (done) {
        jse.libs.datatable.create($this.find('.gx-modules-table'), {
            'dom': 't',
            'autoWidth': false,
            'pageLength': 1000,
            'columnDefs': [{
                'targets': [1, 2],
                'orderable': false
            }],
            'order': []
        });

        if (typeof queryString.module !== 'undefined') {
            _loadModuleData(queryString.module);
        } else {
            $('.gx-configuration-box').css('visibility', 'hidden');
            $('.bottom-save-bar .btn-edit').hide();
        }

        _hashChange();

        $(window).on('hashchange', _hashChange);
        $('.gx-modules-table .dataTableRow').on('click', _setRowActive);
        elements.uninstallButton.on('click', _openUninstallDialog);

        _removeParam('module', window.location.href);

        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
